// (c) Copyright 2024.  Adobe Systems, Incorporated.  All rights reserved.

// This JavaScript is to be read by Bridge, InDesign, and other Adobe apps at
// launch. It enables some InDesign-Bridge integration and implements the
// InDesign CrossDOM for other apps.

/*
@@@BUILDINFO@@@ indesign-20.0.jsx 20.0.0.0
*/

/*
@@@START_XML@@@
<?xml version="1.0" encoding="UTF-8"?>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="en_US">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>This script enables other applications to communicate with Adobe InDesign 2025.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fr_FR">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>Ce script permet à d'autres applications de communiquer avec Adobe InDesign 2025.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ja_JP">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>このスクリプトは、他のアプリケーションと Adobe InDesign 2025 との通信を有効にします。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="de_DE">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>Mithilfe dieses Skripts können andere Anwendungen mit Adobe InDesign 2025 kommunizieren.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="it_IT">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>Questo script consente ad altre applicazioni di comunicare con Adobe InDesign 2025</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="es_ES">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>Este script posibilita que otras aplicaciones se comuniquen con Adobe InDesign 2025</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="nl_NL">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>Dit script laat andere toepassingen toe te communiceren met Adobe InDesign 2025</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="pt_BR">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>Este script permite que outros aplicativos se comuniquem com o Adobe InDesign 2025</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="nb_NO">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>Skriptet gjør at andre programmer kan kommunisere med Adobe InDesign 2025</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="da_DK">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>Dette script betyder, at andre programmer kan kommunikere med Adobe InDesign 2025</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fi_FI">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>Tämän komentosarjan avulla muut sovellukset ja Adobe InDesign 2025 voivat kommunikoida keskenään</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="sv_SE">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>Det här skriptet gör det möjligt för andra program att kommunicera med Adobe InDesign 2025</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="zh_TW">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>此指令碼能讓其他應用程式與 Adobe InDesign 2025 進行通訊。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="zh_CN">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>此脚本使其它应用程序能够与 Adobe InDesign 2025 进行通信</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ko_KR">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>이 스크립트를 사용하면 다른 응용 프로그램에서 Adobe InDesign 2025과(와) 통신할 수 있습니다.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="cs_CZ">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>Tento skript umožňuje ostatním aplikacím komunikovat s aplikací Adobe InDesign 2025.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="pl_PL">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>Ten skrypt umożliwia innym aplikacjom komunikowanie się z programem Adobe InDesign 2025.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="hu_HU">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>Ez a szkript lehetővé teszi más alkalmazások számára, hogy kommunikáljanak az Adobe InDesign 2025 programmal. </dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ru_RU">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>Этот сценарий позволяет другим приложениям осуществлять связь с Adobe InDesign 2025.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="tr_TR">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>Bu komut dosyası diğer uygulamaların Adobe InDesign 2025 ile iletişim kurmasını sağlar.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="uk_UA">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>Цей сценарій активує зв'язок інших програм з Adobe InDesign 2025.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ar_AE">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>يتيح هذا النص التنفيذي للتطبيقات الأخرى أن تتصل بـ Adobe InDesign 2025.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="he_IL">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>סקריפט זה מאפשר ליישומים אחרים לתקשר עם Adobe InDesign 2025.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="el_GR">
     <dc:title>Adobe InDesign 2025</dc:title>
     <dc:description>Αυτή η δέσμη ενεργειών δίνει τη δυνατότητα σε άλλες εφαρμογές να επικοινωνούν με το Adobe InDesign 2025.</dc:description>
</ScriptInfo>
@@@END_XML@@@
*/


// debug level: 0-2 (0:disable, 1:break on error, 2:break at beginning)
// $.level = 1;
// debugger; // launch debugger on next line
//=================================================================
// Setup
// This first portion of the script sets up an object to provide
// scope for all InDesign BridgeTalk related routines to prevent
// name collision with other groups' scripts, defines some common
// utility functions, and adds an automate menu to the Bridge.
//=================================================================

// alert("\"" + BridgeTalk.appName + "\" is loading: indesign-20.0.jsx");

var indesignApp = {};

indesignApp.createInDTestMenuInBridgeApp = false;	// Set to true to see InD test menu

// Some global strings (scoped to avoid collisions)
indesignApp.bridgeTargetName = 					"bridge";
indesignApp.inDesignTargetName =					"indesign";
indesignApp.inDesignVersionedTargetName =		"indesign-20";
indesignApp.inCopyTargetName = 					"incopy";
indesignApp.inDesignServerTargetName =			"indesignserver";

indesignApp.bridgeAppName = 						"bridge";
indesignApp.inDesignAppName = 					"indesign";
indesignApp.inCopyAppName = 						"incopy";
indesignApp.inDesignServerAppName =				"indesignserver";

indesignApp.versionID = 							20.0;
indesignApp.targetName = 							"indesign";

indesignApp.strings4PlaceMenu=[
		/*00*/ "$$$/extendscript/indesign/Menu/Place/InInDesign=In InDesign",
		/*01*/ "$$$/extendscript/indesign/Error/NoOpenDocForPlaceError=Scripted place (indesign.place) requires an active document window."
];

//=================================================================
// CrossDOM/X-DOM
// Implements InDesign's cross DOM API - the a small set of
// operations that are common to all Adobe apps.
//=================================================================

//=======================================================
//	quit() 
//	- Performs the equivalent of File->Exit or File->Close.
//
//	return value
//		undefined
//=======================================================
indesignApp.quit = function ( )
{
	if( BridgeTalk.appName == indesignApp.inDesignTargetName )
	{
		indesignApp.validateScriptVersion(); //Make sure we're using an appropriate version of the DOM
		
		app.quit();
	}
	else
	{
		// Create a new BridgeTalk message for InDesign to invoke Quit
		var btMessage = new BridgeTalk;
		btMessage.target = indesignApp.inDesignVersionedTargetName;
		btMessage.body = "indesignApp.quit();";
		btMessage.send();
	}
}

//=======================================================
//	activate
//	- Activate InDesign (not part of cross DOM)
//=======================================================
indesignApp.activate = function ( )
{
	if( BridgeTalk.appName == indesignApp.inDesignTargetName )
	{
		indesignApp.validateScriptVersion(); //Make sure we're using an appropriate version of the DOM

		app.activate();
	}
	else
	{
		// Create a new BridgeTalk message for InDesign to invoke Activate
		var btMessage = new BridgeTalk;
		btMessage.target = indesignApp.inDesignVersionedTargetName;
		btMessage.body = "indesignApp.activate();";
		btMessage.send();
	}
}

//=======================================================
//	open( files ) 
//	- Performs the equivalent of File->Open on the requested files. 
//	Accepts either an Array object or a single path.
//	
//	return value						undefined
//
//	files										File or Array of File	files to display in new Window
//=======================================================
indesignApp.open = function ( /*list of*/ files )
{
	if( BridgeTalk.appName == indesignApp.inDesignTargetName )
	{
		indesignApp.validateScriptVersion(); //Make sure we're using an appropriate version of the DOM

		app.activate();	// Activate to be sure any dialogs or alerts resulting from the open can be seen by the user.

		var fileArray = indesignApp.extractFileArray ( files ); 

		for ( index = 0; index < fileArray.length; ++index )
		{
			var file = fileArray[index];
			
			app.open( file ); //open the files one at a time to get individual return codes.
		}
	}
	else
	{
		//alert("indesignApp.open: files.toSource() = (" + files.toSource() + ")");
		var fileArray = indesignApp.extractFileArray ( files );

		// Create a new BridgeTalk message for InDesign to invoke Open
		var btMessage = new BridgeTalk;
		btMessage.target = indesignApp.inDesignVersionedTargetName;
		btMessage.body = "indesignApp.open (" + fileArray.toSource() + ");";
		btMessage.send();
	}
}

//=======================================================
//	openAsNew([creation-options]) 
//	- Performs the equivalent of File->New. 
//		If a folder is provided, a new, untitled document should be opened with that folder as its location. 
//		If a path to a file is given, a new document should be opened with the specified name and location. 
//		The creation-options are app-specific.
//
//	return value: 
//		Boolean		True if successful
//=======================================================
indesignApp.openAsNew = function () 
{
	if( BridgeTalk.appName == indesignApp.inDesignTargetName )
	{
		indesignApp.validateScriptVersion(); //Make sure we're using an appropriate version of the DOM

		var showingWindow = true;
		var documentPreset = null;
		
		// Check for valid creation options
		if (arguments.length > 0)
		{
			// [showingWindow]: boolean
			for (var i = 0; i < arguments.length; i++)
			{
				if (typeof(arguments[i]) == "boolean")
				{
					showingWindow = arguments[i];
					break;
				}
			}
			
			// [documentPreset]: object or string(name of preset)
			for (var i = 0; i < arguments.length; i++)
			{
				if (typeof(arguments[i]) == "string")
				{
					documentPreset = arguments[i];
					break;
				}
				if (typeof(arguments[i]) == "object" && arguments[i] instanceof documentPreset)
				{
					documentPreset = arguments[i];
					break;
				}
			}
		}

		// create the new document
		var newDocument = app.documents.add(showingWindow, documentPreset);
		if (newDocument != null)
			return true;
		else
			return false;
		
	}
	else
	{
		// Create a new BridgeTalk message for InDesign to invoke openAsNew
		var btMessage = new BridgeTalk;
		btMessage.target = indesignApp.inDesignVersionedTargetName;
		btMessage.body = "indesignApp.openAsNew (";
		if (arguments.length > 0)
		{
			for (var i = 0; i < arguments.length; i++)
			{
				btMessage.body += arguments[i].toSource();
			}
		}
		btMessage.body += ");";
		
		btMessage.send();
	}
}

//=======================================================
//	print( files ) 
//	- Performs the equivalent of File->Print on the requested files.
//	
//	return value
//		undefined (app.print has no return value)
//	
//	files
//		File or Array of File			files to be printed
//=======================================================
indesignApp.print = function ( /*one or array of*/ files )
{
	if( BridgeTalk.appName == indesignApp.inDesignTargetName )
	{
		indesignApp.validateScriptVersion(); //Make sure we're using an appropriate version of the DOM
		
		var fileArray = indesignApp.extractFileArray ( files ); 
		for ( index = 0; index < fileArray.length; ++index )
		{
			var file = fileArray[index];
			
			app.print( file, /*[printDialog]*/ false /*, [using] printerPreset */ ); //print the files one at a time?
		}
	}
	else
	{
		var fileArray = indesignApp.extractFileArray ( files );

		// Create a new BridgeTalk message for InDesign to invoke Print
		var btMessage = new BridgeTalk;
		btMessage.target = indesignApp.inDesignVersionedTargetName;
		btMessage.body = "indesignApp.print (" + fileArray.toSource() + ");";
		btMessage.send();
	}
}

//=======================================================
//	reveal( file ) 
//	- Gives the target app focus and brings the specified document to the foreground if it is already open.
//	
//	return value
//		Boolean		true if the file was open and was successfully brought to the foreground
//=======================================================
indesignApp.reveal = function ( file ) 
{
	if( BridgeTalk.appName == indesignApp.inDesignTargetName )
	{
		indesignApp.validateScriptVersion(); //Make sure we're using an appropriate version of the DOM

		app.activate();

		// Convert the argument into a File.
		if( typeof file == "string" )
			file = indesignApp.convertPathStrToFile( file );
		
		//alert("indesignApp.reveal: File location is :" + file_location.toString());
		if(app.documents.length != 0)
		{
			//alert("indesignApp.reveal: document count is:" + app.documents.length.toString());

			// Search the open documents to see if any of them are the one in question
			for(myCounter = 0; myCounter < app.documents.length; myCounter++)
			{
				aDocument = app.documents.item(myCounter);
				
				if (aDocument.saved)
				{
					//alert("indesignApp.reveal: Document name is :" + aDocument.fullName.toString());
					if (aDocument.fullName.toString() == file.toString())
					{
						//alert("indesignApp.reveal: We have a match!");
						// Activate this document
						app.activeDocument = aDocument;
						return true;
					}
				}
			}
		}
		return false;
	}
	else
	{
		if( typeof file == "string" )
			file = indesignApp.convertPathStrToFile( file );
			
		// Create a new BridgeTalk message for InDesign to invoke reveal
		var btMessage = new BridgeTalk;
		btMessage.target = indesignApp.inDesignVersionedTargetName;
		btMessage.body = "indesignApp.reveal (" + file.toSource() + ");";
		btMessage.send();
	}
}

//=======================================================
//	place( files, showImportOptions ) 
//	-	Performs the equivalent of the File->Place command on the requested files. 
//		showImportOptions
//			Boolean		true if the ImportOptions dialog should be shown
//
//	return value
//		Boolean		true if the files were successfully placed
//=======================================================
indesignApp.place = function ( files, showImportOptions ) 
{
	var fileArray = indesignApp.extractFileArray ( files ); 
	// alert("indesignApp.place: fileArray.toString() = (" + fileArray.toString() + ")");
	
	if( BridgeTalk.appName == indesignApp.inDesignTargetName )
	{
		
		indesignApp.validateScriptVersion(); //Make sure we're using an appropriate version of the DOM

		app.activate();	// Activate to be sure any dialogs or alerts resulting from the open can be seen by the user.
		
		if (app.documents.length == 0 || app.layoutWindows.length == 0)
		{
			app.documents.add();
		}
		
		var placeOK = true;
		if(app.activeDocument != undefined)
		{
			//alert("indesignApp.place: has active document!");

			placeOK = app.place(fileArray, showImportOptions);
			return placeOK;
 		}
		return false;
	}
	else
	{
		var fileArray = indesignApp.extractFileArray ( files );

		// Create a new BridgeTalk message for InDesign to invoke place
		var btMessage = new BridgeTalk;
		btMessage.target = indesignApp.inDesignVersionedTargetName;
		btMessage.body = "indesignApp.place (" + fileArray.toSource() + "," + showImportOptions + ");";
		btMessage.send();
		return true;
	}
}


//=======================================================
//	executeScript( script ) 
//	- Performs an "eval" on the given script.
//
//	return value
//		Object		The value of evaling the last line of the script
//	
//	script
//		String		The script to be evaled
//=======================================================
indesignApp.executeScript = function ( script )
{
	if( BridgeTalk.appName == indesignApp.inDesignTargetName )
	{
		// Bring InDesign to front if already running
		app.activate();
		eval( script );
	}
	else
	{
		// Create a new BridgeTalk message for InDesign to invoke executeScript
		var btMessage = new BridgeTalk;
		btMessage.target = indesignApp.inDesignVersionedTargetName;
		btMessage.body = script;
		btMessage.send();
	}
}

//=======================================================
//	executeScriptFile
//=======================================================
indesignApp.executeScriptFile = function ( file )
{
	if( BridgeTalk.appName == indesignApp.inDesignTargetName )
	{
		if( typeof file == "string" )
			file = indesignApp.convertPathStrToFile( file );

		var f = File( file );
		f.open( 'r', 'text', '' );
		var script = f.read();
		retval = eval( script );
		f.close();
		return retval;
	}
	else
	{
		if( typeof file == "string" )
			file = indesignApp.convertPathStrToFile( file );

		// Create a new BridgeTalk message for InDesign to invoke executeScriptFile
		var btMessage = new BridgeTalk;
		btMessage.target = indesignApp.inDesignVersionedTargetName;
		btMessage.body = "indesignApp.executeScriptFile (" + file.toSource() + ");";
		btMessage.send();
	}
}

//========================================================================================================
// This routine Makes sure the ID/IC scriptDOM we're working with is set to at least the minimal level required.
indesignApp.validateScriptVersion = function ()
{
	if( BridgeTalk.appName == indesignApp.inDesignTargetName )
	{
		if (app.scriptPreferences.version < 20.0)
			app.scriptPreferences.version = 20.0 ; //New CC defines the 20.0 version of the DOM
	}
}

// This routine sets the argument menu node to be enabled, if indesign is running.
indesignApp.enabledIfRunning = function (menuItem)
{
	if( BridgeTalk.isRunning(indesignApp.inDesignVersionedTargetName) )
		menuItem.enabled = true;
	else
		menuItem.enabled = false;
}

// This routine sets the argument menu node to be enabled if one non-container item is selected.
indesignApp.singleFileSelectionEnabled = function (menuItem)
{
	menuItem.enabled = app.document != undefined && app.document.selectionLength == 1 &&
		app.document.selections[0].container != true;
}

//=======================================================
indesignApp.checkForActiveDocument = function ( ) 
{
	if( BridgeTalk.appName == indesignApp.inDesignTargetName )
	{
		indesignApp.validateScriptVersion(); //Make sure we're using an appropriate version of the DOM

		if (app.documents.length == 0 || app.layoutWindows.length == 0)
			return false;
		
		if(app.activeDocument == undefined || app.activeDocument == null)
			return false;
		
		return true;
	}
	else
	{
		indesignApp.hasActiveDocument = false;
		
		if (BridgeTalk.isRunning(indesignApp.inDesignVersionedTargetName))
		{
			var btMessage = new BridgeTalk;
			btMessage.target = indesignApp.inDesignVersionedTargetName;
			btMessage.body = "indesign.checkForActiveDocument ();";
			btMessage.completed = false;
			btMessage.onResult = function(returnBtObj) {
				indesignApp.hasActiveDocument = eval(returnBtObj.body);
				btMessage.completed = true;
			}			
			btMessage.onError = function(returnBtObj) { indesignApp.hasActiveDocument = false; btMessage.completed = true;}	
			btMessage.send();
	
			// Wait for this message to complete
			//	 This gets a bit tricky because this function is called from the UI menu enabling code in the bridge.
			var timer = 0; 
			while( timer++ < 30 && btMessage.completed == false)
			{
					BridgeTalk.pump();
					$.sleep( 100 );
			}
		}

		return indesignApp.hasActiveDocument;
	}
}

indesignApp.selectionEnabledIfInDesignDocs = function (menuItem)
{
	indesignApp.selectionEnabled(menuItem);
	
	if (menuItem.enabled == false)
		return;
	
	if ( app.document == undefined ) {
		menuItem.enabled = false;
		return;
	}
	
	// Validate that the selected item is an InDesign document
	//	(compare item against valid InDesign document extensions, and type/creator
	var sel = app.document.selections;
	menuItem.enabled = true;
	for (i=0; i < sel.length; i++)
	{
		if (indesignApp.isInDesignDocument(sel[i]) == false)
		{
			menuItem.enabled = false;
			break;
		}
	}
}

indesignApp.selectionEnabledIfIsScriptFile = function (menuItem)
{
	indesignApp.singleFileSelectionEnabled(menuItem);
	
	if (menuItem.enabled == false)
		return;
	
	if ( app.document == undefined ) {
		menuItem.enabled = false;
		return;
	}
	
	// Validate that the selected item is a script file
	var scriptExtensions = ["js", "jsx"];
	menuItem.enabled = indesignApp.matchesFileExtensions(app.document.selections[0], scriptExtensions);	
}

indesignApp.selectionEnabledIfRunningAndIsInDesignDoc = function (menuItem)
{
	if( BridgeTalk.isRunning(indesignApp.inDesignVersionedTargetName) )
		menuItem.enabled = true;
	else
	{
		// alert("InDesign 20.0 isn't running");
		menuItem.enabled = false;
		return;
	}
	
	indesignApp.singleFileSelectionEnabled(menuItem);
	if (menuItem.enabled == false)
		return;
	
	menuItem.enabled = indesignApp.isInDesignDocument(app.document.selections[0]);
}

indesignApp.matchesFileExtensions = function ( aThumbnail, extensionsToMatch )
{
	var period = ".";
	var index = aThumbnail.spec.name.toString().lastIndexOf(period);
	if (index > -1)
	{
		ext = aThumbnail.spec.name.substring(index+1).toLowerCase();
		
		for (var extIndex = 0; extIndex < extensionsToMatch.length; extIndex++ )
		{
			if (ext == extensionsToMatch[extIndex])
				return true;
		}
	}
	return false;
}

indesignApp.matchesMacFileType = function ( fileType, fileTypesToMatch )
{	
	if (fileTypesToMatch.length > 0 && fileType != "????" && fileType != "    " && fileType != null)
	{
		if ( fileType == indesignApp.LastGoodMacType )
			return true;
		
		for (var i = 0; i < fileTypesToMatch.length; i++ )
		{
			if (fileType == fileTypesToMatch[i]) {
				indesignApp.LastGoodMacType = fileType;
				return true;
			}
		}
	}
	return false;
}

indesignApp.isInDesignDocument = function ( aThumbnail )
{
	
	// Check file Extension (.indd)
	var inDesignDocExtensions = ["indd", "indb", "inx", "indt", "indl"];
	var inDesignDocTypes = ["IDd4", "IDb4", "IDd3", "IDx3", "IDd3", "IDl4"]; // FIX - add new types, if any
	if (indesignApp.matchesFileExtensions(aThumbnail, inDesignDocExtensions) == true)
	{
		return true;
	}
	else
	{
		// Else check file type - MacOS only
		// (BRIDGE BUG: getting spec for managed files forces a replica download)
		var aFile = aThumbnail.spec;
		if (indesignApp.matchesMacFileType(aFile.type, inDesignDocTypes))
		{
			return true;
		}
	}
	return false;
}

// This routine sets the argument menu node to be enabled if something is selected.
indesignApp.selectionEnabled = function (menuItem)
{
	menuItem.enabled = false;
	
	if (app.document != undefined && app.document.selectionLength > 0)
	{
		menuItem.enabled = true;
		var sel = app.document.selections;
		for (i=0; i < sel.length; i++)
		{
			if (sel[i].container == true)
			{
				menuItem.enabled = false;
				break;
			}
		}
	}
}

// This routine sets the argument menu node to be enabled if something is selected and app is running.
indesignApp.selectionEnabledIfRunning = function (menuItem)
{
	menuItem.enabled = false;
	
	if( app.document != undefined && app.document.selectionLength > 0 && BridgeTalk.isRunning(indesignApp.inDesignVersionedTargetName) )
	{
		menuItem.enabled = true;
		var sel = app.document.selections;
		for (i=0; i < sel.length; i++)
		{
			if (sel[i].container == true)
			{
				menuItem.enabled = false;
				break;
			}
		}
	}
	else {
		// alert("InDesign 20.0 not running" );
	}
}

indesignApp.selectionEnabledIfIsPlaceable = function (menuItem)
{
	if( app.document != undefined && app.document.selectionLength > 0 && app.document.selectionLength <= 50 ) {
		menuItem.enabled = true;
	}
	else {
		menuItem.enabled = false;
		return;
	}
	
	// Validate that docs are placeable
	menuItem.enabled = true;
	var sel = app.document.selections;
	for (i=0; i < sel.length; i++)
	{
		var aThumbNail = sel[i];
		
		if ( aThumbNail.container == true ) {
			// alert("This is a non-placeable container.");
			menuItem.enabled = false;
			break;
		}
	}
}

indesignApp.mySecretTest = function ()
{
}

//=========================================================================================================================
//-----------------------------------------------------------------
// This routine tries to return an array of File objects created
// from the 'files' argument. It will convert a single File object
// or a single string into an array of File objects, or it will
// convert an array of string and File objects into an array of
// file objects.
//-----------------------------------------------------------------
indesignApp.extractFileArray = function (files)
{
	var fileArray = new Array;
	
	// If it isn't an array, make it a length one array.
	if (!(files instanceof Array))
		files = new Array (files);
	
	// Turn each item in the array into a File, or remove it.
	for (index = 0; index < files.length; ++index)
	{
		var file = files[index];
		
		if (file instanceof File)
			fileArray.push (file);
		else if (typeof file == 'string')
			fileArray.push (File (file));
		else
		{
			// do nothing
		}
	}
	
	return fileArray;
}

indesignApp.convertPathStrToFile = function( file )
{
	return File( file );
}

indesignApp.thumbNailArrayToFileArray = function (/* Array of thumbNails */ thumbNails)
{
	var files = [];

	for (var index = 0; index < thumbNails.length; index++ )
	{
		files.push(thumbNails[index].spec);
	}
	
	return files;
}

// Place the selected document in InDesign.
indesignApp.placeSelectionInInDesign = function (showImportOptions)
{
	var fileArray = indesignApp.thumbNailArrayToFileArray(app.document.selections);
	indesignApp.place (fileArray, showImportOptions);
}

//=======================================================
//	IsAppInstalled( target, versionNumber ) 
//	- Is the specified version of an app installed.
//	
//	return value
//		boolean
//	
//	target
//		string			specifier for the app (i.e. indesign or incopy)
//	versionNumber
//		number			version number (not a string) for the app (i.e. 20.0)
//=======================================================
// 
indesignApp.IsAppInstalled = function(targetName, targetVersionID)
{
	var appNameRoot = targetName+'-';	// 'indesign-' or 'incopy-'

	var thisVersionExists = false;
	
	// Is any version of "targetName" installed 
	if (BridgeTalk.getTargets (0).join ().indexOf (appNameRoot) != -1)
	{
		apps = BridgeTalk.getTargets(0);
		for( var i = 0; i < apps.length; i++ )
		{
			var appspec = apps[i];
			if( appspec.indexOf(appNameRoot) == 0 )
			{
				// Get the versionID for this 
				var versionID = appspec.substring(appspec.indexOf('-')+1)
				
				if ((versionID == targetVersionID) || (versionID.indexOf(targetVersionID) == 0))
				{
					thisVersionExists = true;
				}
			}
		}
	}

	return thisVersionExists;
}

//=====================================================================================================
// Install the Place in InDesign menu items
//	Do this when the latter apps is starting up (InDesign or Bridge) and the other is running.
//     *** Bridge guidance says to to this at Bridge Startup time - don't defer til later ***
//=====================================================================================================
// Install the Place in InDesign menu items.
indesignApp.placeMenuItemsInstalledInBridge = false;
indesignApp.installPlaceMenuItems = function ()
{
	if (BridgeTalk.appName == indesignApp.bridgeAppName)
	{
		if (indesignApp.placeMenuItemsInstalledInBridge == true)
			return;
			
		// alert("Ready to install Place in InDesign menu items.");

 		indesignApp.placeMenu = {};
		var menuExists = MenuElement.find("place_in_indesign");
		if (menuExists)
			MenuElement.remove("place_in_indesign");

		indesignApp.placeMenu.placeItem = MenuElement.create("command", localize (indesignApp.strings4PlaceMenu[0]), "at the end of submenu/Place", "place_in_indesign", indesignApp.inDesignTargetName);
 		indesignApp.placeMenu.placeItem.onDisplay = function () {indesignApp.selectionEnabledIfIsPlaceable(this);};
 		indesignApp.placeMenu.placeItem.onSelect = function() {indesignApp.placeSelectionInInDesign(this.shiftDown);};
		
		indesignApp.placeMenuItemsInstalledInBridge = true;
		// alert("Installation of Place in InDesign menu items is done.");
	}
}

// Install menu in the bridge, but only if InDesign 20.0 is installed, and is the latest version
if (BridgeTalk.appName == indesignApp.bridgeAppName)
{
	if( indesignApp.IsAppInstalled(indesignApp.targetName, indesignApp.versionID) )
		indesignApp.installPlaceMenuItems();
}

//=====================================================================================================
// I n D e s i g n    T e s t    M e n u   (installed into the Bridge app to test integration)
//	Do this when the latter apps is starting up (InDesign or Bridge) and the other is running.
//=====================================================================================================

indesignApp.testMenuInstalledInBridge = false;
indesignApp.installTestMenuInBridge = function ()
{
	if (BridgeTalk.appName == indesignApp.bridgeAppName)
	{
		if (indesignApp.testMenuInstalledInBridge == true)
			return;
			
		//alert("Bridge ready to install InDesign Test menu");
		indesignApp.testMenuInstalledInBridge = true;

		// Create a new menu for testing integration with InDesign, add it after the Bridge's Help menu
		indesignApp.testMenu = {};
		indesignApp.testMenu.menu = MenuElement.create("menu", "InD5Test", "after Help", "inDesignTestMenu", indesignApp.inDesignTargetName);
	 
		// The code below inserts various menu items into the InDesignTest menu.
		indesignApp.testMenu.newDocItem = MenuElement.create("command", "New InDesign Pub", "at the end of inDesignTestMenu", "new_in_indesign_test", indesignApp.inDesignTargetName);
		indesignApp.testMenu.newDocItem.onSelect = function () {indesignApp.openAsNew ();};
 
		indesignApp.testMenu.openItem = MenuElement.create("command", "Open in InDesign", "after new_in_indesign_test", "open_in_indesign_test", indesignApp.inDesignTargetName);
		indesignApp.testMenu.openItem.onDisplay = function () {indesignApp.selectionEnabledIfInDesignDocs(this);};
		indesignApp.testMenu.openItem.onSelect = function () {indesignApp.open (indesignApp.thumbNailArrayToFileArray(app.document.selections));};
	
		indesignApp.testMenu.revealItem = MenuElement.create("command", "Reveal in InDesign", "after open_in_indesign_test", "reveal_in_indesign_test", indesignApp.inDesignTargetName);
		indesignApp.testMenu.revealItem.onDisplay = function () {indesignApp.selectionEnabledIfRunningAndIsInDesignDoc(this);};
		indesignApp.testMenu.revealItem.onSelect = function () {indesignApp.reveal (indesignApp.thumbNailArrayToFileArray(app.document.selections));};
	
		indesignApp.testMenu.printItem = MenuElement.create("command", "Print in InDesign", "after reveal_in_indesign_test", "print_in_indesign_test", indesignApp.inDesignTargetName);
		indesignApp.testMenu.printItem.onDisplay = function () {indesignApp.selectionEnabledIfInDesignDocs(this);};
		indesignApp.testMenu.printItem.onSelect = function () {indesignApp.print (indesignApp.thumbNailArrayToFileArray(app.document.selections));};
	
		indesignApp.testMenu.runScriptItem = MenuElement.create("command", "Run Script in InDesign", "after print_in_indesign_test", "run_indesign_script_test", indesignApp.inDesignTargetName);
		indesignApp.testMenu.runScriptItem.onDisplay = function () {indesignApp.selectionEnabledIfIsScriptFile(this);};
		indesignApp.testMenu.runScriptItem.onSelect = function () {indesignApp.executeScriptFile (indesignApp.thumbNailArrayToFileArray(app.document.selections));};
	
		indesignApp.testMenu.placeItem = MenuElement.create("command", "Place in InDesign", "after run_indesign_script_test", "place_in_indesign_test", indesignApp.inDesignTargetName);
		indesignApp.testMenu.placeItem.onDisplay = function () {indesignApp.selectionEnabledIfIsPlaceable(this);};
		indesignApp.testMenu.placeItem.onSelect = function() {indesignApp.placeSelectionInInDesign(this.shiftDown);};
	
		indesignApp.testMenu.activateItem = MenuElement.create("command", "Activate InDesign", "after place_in_indesign_test", "activate_indesign_test", indesignApp.inDesignTargetName);
		indesignApp.testMenu.activateItem.onDisplay = function () {indesignApp.enabledIfRunning(this);};
		indesignApp.testMenu.activateItem.onSelect = indesignApp.activate;
	
		indesignApp.testMenu.quitItem = MenuElement.create("command", "Quit InDesign", "after activate_indesign_test", "quit_indesign_test", indesignApp.inDesignTargetName);
		indesignApp.testMenu.quitItem.onDisplay = function () {indesignApp.enabledIfRunning(this);};
		indesignApp.testMenu.quitItem.onSelect = indesignApp.quit;
	
		indesignApp.testMenu.sepItem = MenuElement.create("command", "-", "after quit_indesign_test", "sepA_indesign_test", indesignApp.inDesignTargetName);
		indesignApp.testMenu.sepItem.onDisplay = false;
	
		indesignApp.testMenu.aTestItem = MenuElement.create("command", "Private Test", "after sepA_indesign_test", "private_test_indesign_test", indesignApp.inDesignTargetName);
		indesignApp.testMenu.aTestItem.onDisplay = function () {indesignApp.singleFileSelectionEnabled(this);};
		indesignApp.testMenu.aTestItem.onSelect = indesignApp.mySecretTest;
	}
}

// Install menu in the bridge, but only if InDesign 20.0 is installed and is the highest installed version
if (indesignApp.createInDTestMenuInBridgeApp == true)
{
	if (BridgeTalk.appName == indesignApp.bridgeAppName)
 	{
		if( indesignApp.IsAppInstalled(indesignApp.targetName, indesignApp.versionID) )
			indesignApp.installTestMenuInBridge();
 	}
}

//=====================================================================================================
// I n D e s i g n   G e n e r i c   N a m e s p a c e
//		Do this only when this version of InDesign, 20.0, is the highest installed version
//=====================================================================================================

if( indesignApp.IsAppInstalled(indesignApp.targetName, indesignApp.versionID) )
	indesign = indesignApp;   


// alert("Loading: indesign-20.0.jsx -- completed");
